#include "InventorBasicEffectDx10.fxh"

struct VSPosCol
{
	float3 Pos			: Position;
	float4 Col			: Color;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosCol( VSPosCol Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	//Input color is compressed as a Dword in vertex buffer. 
	//But Dx9 is incompatiable to translate this Dword into float4 with Dx10. Dx9 treats Dword as ARGB. Dx10 treats Dword as ABGR.
	//And Dword is padding with order ARGB in application layer. So a translation is needed in Dx10.
	Out.ColorD.xyzw = Input.Col.zyxw;
	
#ifdef DIFFUSE_TEXTURE
	//automatic texture coordinate generation
	Out.Tex += float4(Input.Pos*(g_texCoordType == TEX_COORD_POSITION), 1.0f);
	Out.Tex += float4(ViewPos * (g_texCoordType == TEX_COORD_CAMERASPACEPOSITION), 0);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

	if(g_fogEnabled)
	{
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
	//Apply user specified clipping
    	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
    	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
    	if( g_bClippingEnable )
    	{
		CalcClipping(LocalPos, Out);
    	}
	return Out;
}
//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosCol( VSOutput Input ) : SV_Target
{
#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	if(Input.ColorD.a < g_Misc.w)
		discard;
	float4 Color = saturate(Input.ColorD + Input.ColorS);
if(g_fogEnabled)
	return Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;
else
	return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosCol
{
    pass P0
    {   
		SetVertexShader( CompileShader( vs_4_0, VS_PosCol()) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_PosCol()) );
	}
}